<?xml version="1.0" encoding="UTF-8"?>

<xsl:transform version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xalan="http://xml.apache.org/xalan"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  extension-element-prefixes=""
  exclude-result-prefixes="xalan xs xsl">

  <xsl:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>

  <xsl:variable name="DEBITS" select="document('../temp/debits.xml')"/>
  <xsl:variable name="STATIONS" select="document('../input/stations.xml')"/>


  <!-- ********************************************************************** -->
  <xsl:template match="/sections">

    <xsl:message>NB DEBITS: <xsl:value-of select="count($DEBITS//debit)"/></xsl:message>

    <xsl:text>&#xa;</xsl:text>
    <xsl:copy>
      <xsl:apply-templates select="@*|node()">
        <xsl:sort select="@region"/>
        <xsl:sort select="@riviere"/>
        <xsl:sort select="@section"/>
      </xsl:apply-templates>
    </xsl:copy>

  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template match="section">
      <xsl:variable name="station" select="@station"/>
      <xsl:variable name="debitBrut">
        <xsl:choose>
          <xsl:when test="@niveau='true'">
            <xsl:value-of select="$DEBITS//debit[@station = $station]/@niveau"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="$DEBITS//debit[@station = $station]/@valeur"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name="refoulement" select="contains($debitBrut,'*')"/>
      <xsl:variable name="debitBrut2" select="translate($debitBrut,'*', '')"/>
      <xsl:variable name="debitBrut2B" select="translate($debitBrut2,'.', ',')"/>
      <xsl:variable name="debitBrut2C" select="translate(normalize-space($debitBrut2B),'&#x9;&#xa;&#xd;&#x20; ','')"/>


      <xsl:variable name="debitBrutNoComma" select="translate($debitBrut2C,',', '.')"/>
      <xsl:variable name="debitBrutNoSpace" select="translate($debitBrutNoComma,' &#x20;&#x9;&#xD;&#xA; ', '')"/>

      <xsl:variable name="debitBrut3" as="number" select="number($debitBrutNoSpace)"/>
      
      <xsl:variable name="debitBrutArrondi" as="number" select="round($debitBrut3 * 10) div 10"/>

<!-- DEBUG
      <xsl:message><xsl:value-of select="$debitBrutArrondi"/></xsl:message>
-->
      <xsl:variable name="debitPondere" select="@ponderation * $debitBrut3"/>
      <xsl:variable name="debitPondereArrondi" select="round($debitPondere * 10) div 10"/>

    <xsl:copy>

      <xsl:if test="@min and @min!=''">
        <xsl:choose>
          <xsl:when test="$debitPondereArrondi &lt; @min">
            <xsl:attribute name="zone">red</xsl:attribute>
          </xsl:when>
          <xsl:when test="@bon and @bon!='' and $debitPondereArrondi &lt; @bon">
            <xsl:attribute name="zone">lightyellow</xsl:attribute>
          </xsl:when>
          <xsl:when test="@max and @max!='' and $debitPondereArrondi &gt; @max">
            <xsl:attribute name="zone">cyan</xsl:attribute>
          </xsl:when>
          <xsl:otherwise>
            <xsl:attribute name="zone">lightgreen</xsl:attribute>      
          </xsl:otherwise>
        </xsl:choose>
      </xsl:if>

      <xsl:attribute name="debitStation"><xsl:value-of select="$debitBrutArrondi"/></xsl:attribute>
      <xsl:attribute name="debit"><xsl:value-of select="$debitPondereArrondi"/></xsl:attribute>
      <xsl:attribute name="date"><xsl:value-of select="$DEBITS//debit[@station = $station]/@date"/></xsl:attribute>
      <xsl:attribute name="heure"><xsl:value-of select="$DEBITS//debit[@station = $station]/@time"/></xsl:attribute>
      <xsl:attribute name="refoulement"><xsl:value-of select="$refoulement"/></xsl:attribute>

      <xsl:apply-templates select="@*|node()"/>
      
     </xsl:copy>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

</xsl:transform>
