<?xml version="1.0" encoding="UTF-8"?>

<xsl:transform version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xalan="http://xml.apache.org/xalan"
  xmlns:xs="http://www.w3.org/2001/XMLSchema"
  extension-element-prefixes=""
  exclude-result-prefixes="xalan xs xsl">

  <xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>

  <xsl:variable name="DEBITS" select="document('./debits.xml')"/>
  <xsl:variable name="STATIONS" select="document('../input/stations.xml')"/>
  
  <xsl:variable name="CONTACT_EMAIL" select="'nico.svp@gmail.com'"/>

<xsl:param name="date"/>

  <!-- ********************************************************************** -->
  <xsl:template match="/sections">

  <!-- <!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"> -->
  <html>
    <head>
      <link rel="shortcut icon" href="./favicon.ico" />
      <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>

      <META HTTP-EQUIV="REFRESH" CONTENT="300" />
<meta http-equiv="cache-control" content="max-age=0" />
<meta http-equiv="cache-control" content="no-cache" />
<meta http-equiv="expires" content="0" />
<meta http-equiv="expires" content="Tue, 01 Jan 1980 1:00:00 GMT" />
<meta http-equiv="pragma" content="no-cache" />

      <title>Info-Débile</title>

      <!-- Javascript goes in the document HEAD -->
      <script type="text/javascript">
      function altRows(id){
        if(document.getElementsByTagName){

          var table = document.getElementById(id);
          var rows = table.getElementsByTagName("tr");

          for(i = 0; i &lt; rows.length; i++){
            if(i % 2 == 0){
              rows[i].className = "evenrowcolor";
            }else{
              rows[i].className = "oddrowcolor";
            }
          }
        }
      }
      window.onload=function(){
        altRows('alternatecolor');
      }
      </script>

      <!-- CSS goes in the document HEAD or added to your external stylesheet -->
      <style type="text/css">
      note {
        font-family: verdana,arial,sans-serif;
        font-size:11px;
        color: darkred;
      }

      a {
        font-family: verdana,arial,sans-serif;
        font-size:11px;
      }

      body {
        font-family: verdana,arial,sans-serif;
      }

      table.altrowstable {
        font-family: verdana,arial,sans-serif;
        font-size:11px;
        color:#333333;
        border-width: 1px;
        border-color: #a9c6c9;
        border-collapse: collapse;
      }
      table.altrowstable th {
        border-width: 1px;
        padding: 8px;
        border-style: solid;
        border-color: #a9c6c9;
        background-color:#BBBBBB;
      }
      table.altrowstable td {
        border-width: 1px;
        padding: 8px;
        border-style: solid;
        border-color: #a9c6c9;
      }
      .oddrowcolor{
        background-color:#d4e3e5;
      }
      .evenrowcolor{
        background-color:#c3dde0;
      }
      </style>

      </head>
      <body>

      <H1>Info-Débile</H1>
     
      <H4>Légende</H4>
      <table class="altrowstable" id="legende">
        <tr align="center">
          <td bgcolor="red" width="80">trop bas</td>
          <td bgcolor="white"><b>(Min)</b></td>
          <td bgcolor="lightyellow" width="80"><u>(probablement)</u><BR/>acceptable</td>
          <td bgcolor="white"><b>(Bon)</b></td>
          <td bgcolor="lightgreen" width="80">idéal</td>
          <td bgcolor="white"><b>(Haut)</b></td>
          <td bgcolor="cyan" width="80">excitant et/ou dangereux *</td>
        </tr>
      </table>
      <note>* le débit 'Haut' a une définition très subjective. Interpréter comme "déconseillé" à défaut d'autres informations/références.</note>
      
      <p/>

      <H4>Attention</H4>
      <font style="font:12px sans-serif">
      <ul>
      <li>Les débits sont à titre indicatif seulement. Les débits  sont parfois extrapolés à partir d'une station à plusieurs dizaines de km en aval, station également  influencée par de nombreux tributaires  ou à partir d'une station sur un autre basin versant.</li>
      <li>Selon votre bateau (kayak, canot, bateau gonflable),  votre expérience, vos attentes et  le matériel transporté, le jugement des débits trop bas, acceptables, idéal et haut peut varier"</li>
      </ul>
      </font>

      <H4>Nous Aider</H4>
      <font style="font:12px sans-serif">
      <p>svp nous partager vos observations et corrections:
      <ul>
        <li>en ajoutant des commentaires dans ce fichier: <a target="_blank" href="https://docs.google.com/spreadsheets/d/1g-4c66e2q67aML4-2KWGjzuvJMEoI8xr1SlTjtqWkAw/edit?usp=sharing">https://docs.google.com/spreadsheets/d/1g-4c66e2q67aML4-2KWGjzuvJMEoI8xr1SlTjtqWkAw/edit?usp=sharing</a></li>
        <li>ou par courriel pour toute autre suggestion/correction: <a href="mailto:nico.svp@gmail.com">nico.svp@gmail.com</a></li>
      </ul>
      </p>
      </font>

      <H2>Débits</H2>

      <!-- TOC -->
      <ul>
        <xsl:apply-templates select="@*|node()" mode="toc"/>
      </ul>
      
      <note>Dernière mise à  jour: <xsl:value-of  select="$date"/>.</note>
      <table class="altrowstable" id="alternatecolor">
        <xsl:apply-templates select="@*|node()"/>
      </table>

    <xsl:text>&#xa;</xsl:text>
    <xsl:copy>
    </xsl:copy>


    </body>
    </html>

  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template name="writeHeader">
    <xsl:param name="nomRegion" value="'Region'"/>
      <thead>
        <tr>
          <th><xsl:value-of select="$nomRegion"/></th>
          <th>Riviere</th>
          <th>Section</th>
          <th>Debit</th>
          <th>Date</th>
          <th>Min</th>
          <th>Bon</th>
          <th>Haut</th>
          <th>Station</th>
          <th>Débit station</th>
          <th>Ponderation</th>
          <th>Note</th>
        </tr>
      </thead>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template match="section" mode="toc">
    <xsl:if test="not(preceding-sibling::section[@region = current()/@region])">
      <li><a href="#{@region}"><xsl:value-of select="@region"/></a></li>
    </xsl:if>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template match="section">

    <xsl:if test="not(preceding-sibling::section[@region = current()/@region])">
      <xsl:variable name="regionUpcase" select="translate(@region,'abcdefghijklmnopqrstuvwxyzéèêô','ABCDEFGHIJKLMNOPQRSTUVWXYZÉÈÊÔ')"/>
      <xsl:call-template name="writeHeader">
        <xsl:with-param name="nomRegion" select="$regionUpcase"/>
      </xsl:call-template>
    </xsl:if>
    
    <tbody>
      
      <tr>
        <td><a name="{@region}"/><xsl:value-of select="@region"/></td>
        <td><xsl:value-of select="@riviere"/></td>
        <td><xsl:value-of select="@section"/></td>
        <td>
          <xsl:choose>
            <xsl:when test="@debit='NaN'">---</xsl:when>
            <xsl:otherwise>
              <xsl:if test="@zone"> 
                <xsl:attribute name="bgcolor"><xsl:value-of select="@zone"/></xsl:attribute>
              </xsl:if> 
              <xsl:value-of select="@debit"/>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:if test="@refoulement='true'"><xsl:text> (glace)</xsl:text></xsl:if>
        </td>
        <td>
          <xsl:value-of select="@date"/>
          <xsl:if test="@heure!=''"><xsl:text> </xsl:text><xsl:value-of select="@heure"/></xsl:if>
        </td>
        <td><xsl:value-of select="@min"/></td>
        <td><xsl:value-of select="@bon"/></td>
        <td><xsl:value-of select="@max"/></td>
        <td>
          <xsl:variable name="numeroStation" select="@station"/>
          <xsl:variable name="data" select="$STATIONS//stations/station[@code=$numeroStation]"/>
          <xsl:variable name="description">
            <xsl:choose>
              <xsl:when test="string-length($data/@description) != 0"><xsl:value-of select="$data/@nom"/><xsl:text> - </xsl:text><xsl:value-of select="$data/@description"/></xsl:when>
              <xsl:otherwise>INFO STATION MANQUANTE</xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          
          <xsl:choose>
            <xsl:when test="$data/@type='USGS'">
              <a title="{$description}" target="_blank" href="https://waterdata.usgs.gov/ny/nwis/uv?{@station}"><xsl:value-of select="@station"/></a>
            </xsl:when>
            <xsl:otherwise>
              <a title="{$description}" target="_blank" href="http://www.cehq.gouv.qc.ca/suivihydro/graphique.asp?NoStation={@station}"><xsl:value-of select="@station"/></a>
            </xsl:otherwise>
          </xsl:choose>
          <xsl:if test="string-length($data/@nom) != 0">
            <br/>
            <xsl:text>(</xsl:text><xsl:value-of select="$data/@nom"/><xsl:text>)</xsl:text>
          </xsl:if>              
        </td>
        <td>
          <xsl:choose>
            <xsl:when test="@debitStation='NaN'">---</xsl:when>
            <xsl:otherwise><xsl:value-of select="@debitStation"/></xsl:otherwise>
          </xsl:choose>
        </td>
        <td><xsl:value-of select="@ponderation"/></td>
        <td>
          <xsl:value-of select="@note" disable-output-escaping="yes"/>
          <xsl:for-each select="a">
            <br/>
            <xsl:apply-templates select="."/>
          </xsl:for-each>
          <xsl:call-template name="processObservations"/>
        </td>
      </tr>
    </tbody>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template name="processObservations">
    <xsl:call-template name="processObservationsTexte"/>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template name="processObservationsDropDown">
    <xsl:if test="obs">
      <select>
        <option value="">OBSERVATIONS</option>
         <xsl:for-each select="obs">
           <xsl:sort select="@debit" data-type="number"/>
           <option>
             <xsl:if test="@source"><xsl:value-of select="@source"/>
               <xsl:if test="@bateau"><xsl:text>(</xsl:text><xsl:value-of select="@bateau"/><xsl:text>)</xsl:text></xsl:if>
               <xsl:text> - </xsl:text>
             </xsl:if>
             <xsl:if test="@debit"><xsl:value-of select="@debit"/><xsl:text>: </xsl:text></xsl:if>
             <xsl:value-of select="@note"/>
           </option>
         </xsl:for-each>
       </select>
    </xsl:if>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template name="processObservationsTexte">
    <xsl:if test="obs">
      <!--
      <H4>OBSERVATIONS</H4>
      -->
      <ul>
         <xsl:for-each select="obs">
           <xsl:sort select="@debit" data-type="number"/>
           <li>
             <xsl:if test="@source"><xsl:value-of select="@source"/>
               <xsl:if test="@bateau"><xsl:text>(</xsl:text><xsl:value-of select="@bateau"/><xsl:text>)</xsl:text></xsl:if>
               <xsl:text> - </xsl:text>
             </xsl:if>
             <xsl:if test="@debit"><xsl:value-of select="@debit"/><xsl:text>: </xsl:text></xsl:if>
             <xsl:value-of select="@note"/>
           </li>
         </xsl:for-each>
      </ul>
    </xsl:if>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template name="processObservationsMouseOver">
    <xsl:if test="obs">
      <p title="Bla bla"><u>OBSERVATIONS</u></p>
    </xsl:if>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template name="processObservationsTextArea">
    <xsl:if test="obs">
      <textarea height="1px">OBSERVATIONS
      Bla bla</textarea>
    </xsl:if>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>

  <!-- ********************************************************************** -->
  <xsl:template match="@*|node()" mode="toc">
    <xsl:apply-templates select="@*|node()" mode="toc"/>
  </xsl:template>


</xsl:transform>
